clear all
close all
clc

% Ground properties
k = 2.5;        % thermal conductivity [W/m·K]
rho = 2500;     % density [kg/m^3]
cp = 1000;      % specific heat capacity [J/kg·K]
ag = k / (rho * cp); % thermal diffusivity [m^2/s]

% Borehole properties
q = 50;          % heat rate per unit length [W/m]
H = 100;         % borehole length [m]
z = H/2;           % observation point depth (midpoint of the borehole)

% Space and time discretization
r = linspace(0.1, 10, 100);  % radial distances [m]
t = linspace(1, 3600, 100);  % time [s]

% Preallocate temperature change matrix
deltaT = zeros(length(r), length(t));

 for i = 1:length(r)
    for j = 1:length(t)
        fun=@(y) erfc((sqrt(r(i)^2+(z-y).^2))/(2*sqrt(ag*t(j))))./(sqrt(r(i)^2+(z-y).^2))-erfc((sqrt(r(i)^2+(z ...
            +y).^2))/(2*sqrt(ag*t(j))))./(sqrt(r(i)^2+(z+y).^2));

         %fun = @(y) (erfc((r(i).^2 + (z-y).^2)./(2*sqrt(alpha*t(j)*r(i).^2))) - erfc((r(i).^2 + (z+y).^2)./(2*sqrt(alpha*t(j)*r(i).^2))))./r(i);
         deltaT(i,j) = (q/(4*pi*k)) .* integral(fun, 0, H);
         Tfout(i,j)=6+deltaT(i,j);
     end
 end

% Create a meshgrid for plotting
[R, T] = meshgrid(r, t);

% Plot
figure;
surf(R, T, deltaT, 'EdgeColor', 'none');
xlabel('Radial Distance (m)');
ylabel('Time (s)');
zlabel('Temperature Change (K)');
title('Finite Line Source Model (with Integrals) for Borehole Thermal Energy Storage');
colorbar;
view(3);
